# Copyright (C) 2020, 2021 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Upload.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

import pgwui_upload_core.check_settings

PGWUI_COMPONENT = 'pgwui_upload'


def check_settings(component_config):
    '''Check that all pgwui_upload specific settings are good.
    This includes:
      checking for unknown settings
      checking for missing required settings
      checking the boolean settings
      checking that the values of other settings are valid
    '''
    errors = []
    errors.extend(pgwui_upload_core.check_settings.check_settings(
        PGWUI_COMPONENT,
        pgwui_upload_core.check_settings.UPLOAD_SETTINGS,
        pgwui_upload_core.check_settings.REQUIRED_SETTINGS,
        pgwui_upload_core.check_settings.BOOLEAN_SETTINGS,
        pgwui_upload_core.check_settings.BOOLEAN_CHOICE_SETTINGS,
        component_config))

    return errors
