<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<%doc>
  Copyright (C) 2020 The Meme Factory, Inc.  http://www.karlpinc.com/
 
     This file is part of PGWUI_Menu.
    
     This program is free software: you can redistribute it and/or
     modify it under the terms of the GNU Affero General Public License
     as published by the Free Software Foundation, either version 3 of
     the License, or (at your option) any later version.
    
     This program is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     Affero General Public License for more details.
    
     You should have received a copy of the GNU Affero General Public
     License along with this program.  If not, see
     <http://www.gnu.org/licenses/>.
 
  Template providing menu elements for PGWUI components.
 
  Karl O. Pinc <kop@karlpinc.com>

  This template uses the following variables in its context:

    menu_items  A list of (name, url, label) tuples:
         name  The name of the pgwui_component
         url   The url of the menu item
         conf  The component's menu configuration, a dict with the keys:
                 menu_label   The label of the menu item

    pgwui_menu  A dict of the pgwui_menu configuration settings.

</%doc>

<%!
    from pgwui_common.path import asset_abspath

    base_mak = asset_abspath('pgwui_common:templates/base.mak')
%>

<%inherit file="${base_mak}" />
<%block name="title">${pgwui_menu['menu_label']}</%block>
<%block name="stylesheet_links">
  ${parent.stylesheet_links()}
  <link rel="stylesheet"
        href="${request.static_url('pgwui_menu:static/pgwui_menu.css')}"
        type="text/css" />
</%block>

<%def name="navbar_content()">
  ${parent.navbar_content()}
  % if 'pgwui_logout' in pgwui['urls']:
    | <a href="${pgwui['urls']['pgwui_logout']}">Logout</a>
  % endif
</%def>

<ul>
  % for (name, url, conf) in menu_items:
    <li><a href="${url}">${conf['menu_label']}</a></li>
  % endfor
</ul>
