# Copyright (C) 2018, 2020, 2021 The Meme Factory, Inc.
# http://www.karlpinc.com/

# This file is part of PGWUI_Menu.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

'''Provide a way to configure a menu of PGWUI, or other, components.
'''

PGWUI_COMPONENT = 'pgwui_menu'
DEFAULT_MENU_ROUTE = '/'
DEFAULT_MENU_MENU_LABEL = 'PGWUI Menu -- Main Menu'


def establish_settings(config):
    '''Add default menu information into settings when they are not present
    '''
    settings = config.get_settings()
    pgwui = settings.setdefault('pgwui', dict())
    pgwui.setdefault(PGWUI_COMPONENT, dict())
    pgwui[PGWUI_COMPONENT].setdefault(
        'menu_label', DEFAULT_MENU_MENU_LABEL)


def includeme(config):
    '''Pyramid configuration for PGWUI_Menu
    '''
    establish_settings(config)
    config.add_static_view(
        f'static/{PGWUI_COMPONENT}',
        'pgwui_menu:static/',
        cache_max_age=3600)
    config.add_route(PGWUI_COMPONENT, DEFAULT_MENU_ROUTE)
    config.scan()
