# Copyright (C) 2020 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Menu.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

from pgwui_common.exceptions import SetupError as MenuError


# PGWUI setting related exceptions

class BadOrderItemError(MenuError):
    def __init__(self, components, value):
        super().__init__(
            'The "pgwui.pgwui_menu.order" PGWUI setting must be '
            f'an installed PGWUI component name; installed are: {components}; '
            f'({value}) was supplied')


class BadOrderValuesError(MenuError):
    def __init__(self, value):
        super().__init__(
            'The "pgwui.pgwui_menu.order" PGWUI setting must be '
            f'a list of PGWUI component names; ({value}) was supplied')
