# Copyright (C) 2018, 2019, 2020, 2021 The Meme Factory, Inc.
# http://www.karlpinc.com/

# This file is part of PGWUI_Develop.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

# See: https://pytest-cov.readthedocs.io/en/latest/plugins.html


import pytest

import sys

from pgwui_develop import testing


# Test functions

#
# make_mock_fixture()
#

# Function to test mocking
def func_to_mock():
    return 'mocked'


mocked_func = testing.make_mock_fixture(
    sys.modules[__name__], 'func_to_mock')


@pytest.mark.unittest
@pytest.mark.integrationtest
def test_make_mock_fixture_fixture(mocked_func):
    # The mock of the function works

    test_value = 'test value'
    mocked_func.return_value = test_value
    result = mocked_func()

    assert result == test_value


#
# make_magicmock_fixture()
#

magic_mocked_func = testing.make_magicmock_fixture(
    sys.modules[__name__], 'func_to_mock')


@pytest.mark.unittest
@pytest.mark.integrationtest
def test_make_magicmock_fixture_no_autospec(magic_mocked_func):
    # The mock of the function works

    test_value = 'test value'
    magic_mocked_func.return_value = test_value
    result = magic_mocked_func()

    assert result == test_value


magic_mocked_autospecced_func = testing.make_magicmock_fixture(
    sys.modules[__name__], 'func_to_mock', autospec=True)


@pytest.mark.unittest
@pytest.mark.integrationtest
def test_make_magicmock_fixture_autospec(magic_mocked_autospecced_func):
    # The mock of the function works

    test_value = 'test value'
    magic_mocked_autospecced_func.return_value = test_value
    result = magic_mocked_autospecced_func()

    assert result == test_value


#
# instance_method_mock_fixture()
#

normal_return_value = 'not mocked'


# Class for mock testing
class TestClass():

    def method_to_mock(self):
        return normal_return_value


mocked_method = testing.instance_method_mock_fixture('method_to_mock')


@pytest.mark.unittest
@pytest.mark.integrationtest
def test_instance_method_mock_fixture(mocked_method):
    # The mock of the instance method works

    test_value = 'mocked value'
    cls = TestClass()
    mocked_method(cls).return_value = test_value

    result = cls.method_to_mock()

    assert result == test_value


@pytest.mark.unittest
@pytest.mark.integrationtest
def test_instance_method_mock_fixture_unmocked():
    # The test class works after the mocking

    cls = TestClass()
    result = cls.method_to_mock()

    assert result == normal_return_value
