# Copyright (C) 2020, 2021 The Meme Factory, Inc.
# http://www.karlpinc.com/

# This file is part of PGWUI_Develop.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

# See: https://pytest-cov.readthedocs.io/en/latest/plugins.html

import pytest

from pgwui_develop import pytest_plugin_helpers


# pgwui_entry_point()

@pytest.mark.unittest
def test_pgwui_entry_point_there(monkeypatch):
    '''True when the component is a pgwui.components entry point
    '''
    test_name = 'pgwui_example'

    class MockEntryPoint():
        def __init__(self, module_name):
            self.module_name = module_name

    monkeypatch.setattr(
        pytest_plugin_helpers.pkg_resources, 'iter_entry_points',
        lambda *args: [MockEntryPoint(test_name)])

    assert (
        pytest_plugin_helpers.pgwui_entry_point(test_name)(test_name)
        is True)


@pytest.mark.unittest
def test_pgwui_entry_point_not_there(monkeypatch):
    '''False when the component is not pgwui.components entry point
    '''
    monkeypatch.setattr(
        pytest_plugin_helpers.pkg_resources, 'iter_entry_points',
        lambda *args: [])

    assert (pytest_plugin_helpers.pgwui_entry_point('foo')('foo')
            is False)
