# Copyright (C) 2018, 2019, 2020, 2021 The Meme Factory, Inc.
# http://www.karlpinc.com/

# This file is part of PGWUI_Develop.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

# See: https://pytest-cov.readthedocs.io/en/latest/plugins.html

import pytest

# Allow use of the testdir fixture
pytest_plugins = ("pytester",)


# Test fixtures


# pgwui_component_entry_point()
# pgwui_check_settings_entry_point()

@pytest.mark.unittest
def test_pgwui_develop_fixtures(testdir):
    '''Test the fixtures supplied by the pytest_plugin module
    '''
    testdir.makepyfile(
        '''
        from pgwui_develop import pytest_plugin_helpers
        import pytest

        from unittest import mock

        from pyramid.config import (
            Configurator
        )
        from pyramid.threadlocal import (
            get_current_request
        )


        # Activiate our pytest plugin
        pytest_plugins = ("pgwui_develop",)

        # pyramid_config

        def test_pyramid_config(pyramid_config):
            # A pyramid_config is a Configurator instance
            result = pyramid_config
            assert isinstance(result, Configurator)


        # pyramid_test_config

        def test_pyramid_request_config(pyramid_request_config):
            # Is a Configurator instance and has a non-None request
            result = pyramid_request_config
            assert isinstance(result, Configurator)
            assert get_current_request() is not None


        @pytest.fixture
        def mock_pgwui_entry_point(monkeypatch):
            mocked = mock.Mock(
                spec=getattr(pytest_plugin_helpers, 'pgwui_entry_point'),
                name='pgwui_entry_point')
            monkeypatch.setattr(pytest_plugin_helpers, 'pgwui_entry_point',
                                 mocked)
            return mocked


        # pgwui_component_entry_point

        def test_pgwui_component_entry_point(
                mock_pgwui_entry_point, pgwui_component_entry_point):
            #Calls pgwui_entry_point

            pgwui_component_entry_point('pgwui_example')
            mock_pgwui_entry_point.assert_called_once()


        # pgwui_check_settings_entry_point

        def test_pgwui_check_settings_entry_point(
                mock_pgwui_entry_point, pgwui_check_settings_entry_point):
            #Calls pgwui_entry_point

            pgwui_check_settings_entry_point('pgwui_example')
            mock_pgwui_entry_point.assert_called_once()


        '''
    )

    result = testdir.runpytest()

    result.assert_outcomes(passed=4)
