[tox]
envlist = py{34,35,36,37}

[testenv]
basepython =
    py34: python3.4
    py35: python3.5
    py36: python3.6
    py37: python3.7
deps =
    check-manifest
    cmarkgfm
    flake8
    pgwui_develop
    pytest
    pytest-cov
    twine
    # coverage
commands =
    check-manifest
    python setup.py sdist
    twine check dist/*
    flake8 .
    py.test -m unittest --cov=${component.lower()} tests/
    py.test -m 'not unittest' --cov=${component.lower()} tests/
    # coverage run  --source src/${component.lower()} -m py.test
    # coverage report

[flake8]
exclude = .tox,*.egg,build,data,devel
select = E,W,F
ignore = W503

[pytest]
markers =
  unittest
  integrationtest
