# Copyright (C) 2018, 2019, 2020, 2021 The Meme Factory, Inc.
# http://www.karlpinc.com/

# This file is part of ${component}.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

import pytest
from pyramid.testing import DummyRequest
from pyramid.threadlocal import get_current_request, get_current_registry
from pgwui_common.__init__ import includeme as pgwui_common_includeme
from pgwui_core import constants
from pgwui_upload.__init__ import includeme as pgwui_upload_includeme
from ${component.lower()}.views import ${short_name}

# Activiate our pytest plugin
pytest_plugins = ("pgwui",)


# Constants
CHANGED_RESPONSE = {
    'db': 'somedb',
    'db_changed': True,
    'filename': 'file',
    'lines': 5,
    'null_rep': 'NULL',
    'table': 'sometable',
    'trim_upload': constants.CHECKED,
    'upload_null': constants.CHECKED,
    'user': 'someuser',
}

UNCHANGED_RESPONSE = {'db_changed': False}


# Tests

# ${short_name}_view()

@pytest.fixture
def return_log_tuples(isolate_upload_view, caplog):
    '''Get result and the caplog.record_tuples from the upload_view() call'''
    caplog.set_level(logging.DEBUG)

    def run(response):
        isolate_upload_view(response)
        result = ${short_name}.${short_name}_view(get_current_request())
        del result['pgwui']  # Remove variables added by pgwui view decorators

        return (result, caplog.record_tuples)

    return run


def test_upload_view_db_not_changed(return_log_tuples):
    '''When the db did not change nothing logs'''
    response = UNCHANGED_RESPONSE
    (result, log_tuples) = return_log_tuples(response)
    assert result == response
    assert log_tuples == []


def test_upload_view_db_changed_csv(return_log_tuples):
    '''When the db did change from CSV input something logs'''
    response = CHANGED_RESPONSE
    response['csv_checked'] = constants.CHECKED
    (result, log_tuples) = return_log_tuples(response)

    assert result == response
    assert ([tup[:2] for tup in log_tuples]
            == [('pgwui_upload.views.upload', logging.INFO)])


def test_upload_view_db_changed_no_csv(return_log_tuples):
    '''When the db did change from not-CSV input something logs'''
    response = CHANGED_RESPONSE
    response['csv_checked'] = constants.UNCHECKED
    (result, log_tuples) = return_log_tuples(response)

    assert result == response
    assert ([tup[:2] for tup in log_tuples]
            == [('pgwui_upload.views.upload', logging.INFO)])
