# Copyright (C) 2020, 2021 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of ${component}.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

import pytest

import ${component.lower()}.check_settings as check_settings

from pgwui_common import checkset
from pgwui_develop import testing
from ${component.lower()} import exceptions as ${component_lower()}_ex

# Activiate the PGWUI pytest plugin
pytest_plugins = ("pgwui",)


# Module packaging test

def test_check_setting_is_pgwui_check_settings(
        pgwui_check_settings_entry_point):
    '''Ensure that ${component.lower()} has a pgwui.check_settings entry point
    '''
    assert (pgwui_check_settings_entry_point('${component.lower()}.check_settings')
            is True)


# Mocks

mock_unknown_settings = testing.make_mock_fixture(
    checkset, 'unknown_settings')

mock_require_settings = testing.make_mock_fixture(
    checkset, 'require_settings')

mock_boolean_settings = testing.make_mock_fixture(
    checkset, 'boolean_settings')


# validate_example_on_off_ask()

@pytest.mark.parametrize(
    ('settings', 'error_class'), [
        ({}, None),
        ({'example_on_off_ask': 'on'}, None),
        ({'example_on_off_ask': 'off'}, None),
        ({'example_on_off_ask': 'ask'}, None),
        ({'example_on_off_ask': 'bad'},
         ${component.lower()}_ex.ExampleOnOffAskError)])
@pytest.mark.unittest
def test_validate_example_on_off_ask(settings, error_class):
    '''No error is delivered when there's no setting'''
    errors = []
    check_settings.validate_example_on_off_ask(errors, settings)

    if error_class:
        assert len(errors) == 1
        assert isinstance(
            errors[0], error_class)
    else:
        assert errors == []


literal_err = 'literal column headings error'
mock_validate_example_on_off_ask = testing.make_mock_fixture(
    check_settings, 'validate_example_on_off_ask',
    wraps=lambda errors, *args: errors.append(literal_err))


# check_settings()

@pytest.mark.unittest
def test_check_settings(mock_unknown_settings,
                        mock_require_settings,
                        mock_boolean_settings,
                        mock_validate_example_on_off_ask):
    '''The setting checking functions are called once, the check_settings()
    call returns all the errors from each mock.
    '''

    unknown_retval = ['unk err']
    require_retval = ['req err']
    boolean_retval = ['bool err']

    mock_unknown_settings.return_value = unknown_retval
    mock_require_settings.return_value = require_retval
    mock_boolean_settings.return_value = boolean_retval

    result = check_settings.check_settings({})

    mock_unknown_settings.assert_called_once
    mock_require_settings.assert_called_once
    mock_boolean_settings.assert_called_once
    mock_validate_example_on_off_ask.assert_called_once

    assert result.sort() == ([literal_err]
                             + unknown_retval
                             + require_retval
                             + boolean_retval).sort()
