# Copyright (C) 2015, 2018, 2020, 2021 The Meme Factory, Inc.
# http://www.karlpinc.com/

# This file is part of ${component}.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

from pyramid.view import view_config
import logging

from pgwui_common.view import auth_base_view

from ${component.lower()} import exceptions as ${short_name}_ex


log = logging.getLogger(__name__)


@view_config(route_name='${component.lower()}',
             renderer='${component.lower()}:templates/${short_name}.mak')
@auth_base_view
def ${short_name}_view(request):

    response = UploadEngine(YOURUploadHandler(request)).run()

    settings = request.registry.settings
    response.setdefault('pgwui', dict())
    response['pgwui']['${component.lower()}'] = settings['pgwui']['${component.lower()}']

    if response['db_changed']:
        if is_checked(response['csv_checked']):
            upload_fmt = 'CSV'
        else:
            upload_fmt = 'TAB'
        log.info('Successful ${short_name}: DB {db}: Table ({table}):'
                 ' File ({filename}): Lines {lines}:'
                 ' Format {format}: Upload Null {null}: Null Rep ({null_rep}):'
                 ' Trim {trim}: By user {user}'
                 .format(filename=response['filename'],
                         lines=response['lines'],
                         format=upload_fmt,
                         null=is_checked(response['upload_null']),
                         null_rep=escape_eol(response['null_rep']),
                         trim=is_checked(response['trim_upload']),
                         db=response['db'],
                         table=response['table'],
                         user=response['user']))
    return response
