# Copyright (C) 2018, 2020, 2021 The Meme Factory, Inc.
# http://www.karlpinc.com/

# This file is part of ${component}
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

'''Provide a way to configure this PGWUI component.
'''
PGWUI_COMPONENT = '${component.lower()}'
DEFAULT_${short_name.upper()}_ROUTE = '/${short_name}'
DEFAULT_${short_name.upper()}_MENU_LABEL = '${short_name} -- Description of ${component}'


def establish_settings(config):
    '''Add defaults to settings when they are not present
    '''
    settings = config.get_settings()
    pgwui = settings.setdefault('pgwui', dict())
    pgwui.setdefault(PGWUI_COMPONENT, dict())
    pgwui[PGWUI_COMPONENT].setdefault(
        'menu_label', DEFAULT_${short_name.upper()}_MENU_LABEL)


def includeme(config):
    '''Pyramid configuration for ${component}
    '''
    establish_settings(config)
    config.add_route(PGWUI_COMPONENT, DEFAULT_${short_name.upper()}_ROUTE)
    config.scan()
