# Copyright (C) 2020 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of ${component}.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

from pgwui_common import exceptions as common_ex
from pgwui_core import exceptions as core_ex


# PGWUI setting related exceptions

class Error(common_ex.SetupError):
    pass


class ExampleOnOffAskError(SetupError):
    def __init__(self, value):
        super().__init__(
            'The "pgwui:${component}:example_on_off_ask" PGWUI setting '
            ' must be "on", "off", "ask", or not present')

class ExampleDetailedError(SetupError):
    def __init__(self, e, descr='', detail=''):
        super().__init__('Detailed error', descr=descr, detail=detail)
