# Copyright (C) 2020 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of ${component}.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

from pgwui_common import checkset
from . import exceptions as ex


PGWUI_COMPONENT = '${component.lower()}'
${short_name.upper()}_SETTINGS = ['menu_label',
                   # An example setting needing custom validation
                   'example_on_off_ask',
                   ]
REQUIRED_SETTINGS = []
BOOLEAN_SETTINGS = []


# Example validation code
def validate_example_on_off_ask(errors, settings):
    '''Make sure the values are those allowed
    '''
    value = settings.get('literal_column_headings')
    if value is None:
        return
    if value not in ('on', 'off', 'ask'):
        errors.append(ex.ExampleOnOffAskError(value))


def check_settings(component_config):
    '''Check that all ${component.lower()} specific settings are good.
    This includes:
      checking for unknown settings
      checking for missing required settings
      checking the boolean settings
      checking that the values of other settings are valid
    '''
    errors = []
    errors.extend(checkset.unknown_settings(
        PGWUI_COMPONENT, ${short_name.upper()}_SETTINGS, component_config))
    errors.extend(checkset.require_settings(
        PGWUI_COMPONENT, REQUIRED_SETTINGS, component_config))
    errors.extend(checkset.boolean_settings(
        PGWUI_COMPONENT, BOOLEAN_SETTINGS, component_config))
    validate_example_on_off_ask(errors, component_config)

    return errors
