"""A setuptools based setup module.

Copied from:
https://github.com/pypa/sampleproject
It's license applies to this file.
"""
# Copyright (c) 2016 The Python Packaging Authority (PyPA)
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.


# Always prefer setuptools over distutils
from setuptools import setup, find_packages
# To use a consistent encoding
from codecs import open
from os import path


# Get the long description from the README file
def filter_readme():
    '''Return README content with copyright at top removed'''
    lines = []
    past_copyright = False
    with open(path.join(here, 'README.rst'), encoding='utf-8') as f:
        for line in f:
            if past_copyright:
                lines.append(line)
            else:
                if line == '.. #End Of Copyright Marker#\n':
                    past_copyright = True
    return ''.join(lines)


here = path.abspath(path.dirname(__file__))

# Get program version
with open(path.join(here, 'src', '${component.lower()}', 'VERSION'),
          encoding='utf-8') as version_file:
    version = version_file.read().strip()

# Get the long description from the README file
long_description = filter_readme()

# Pyramid testing requirements
tests_require = [
    'pgwui_develop==' + version,
    'WebTest >= 1.3.1',  # py3 compat
    'pytest>=3.7.4',
    'pytest-cov',
]

setup(
    name='${component.lower()}',

    # Versioning is major.minor.fixes.  Major releases change (after 1.0.0)
    # when backward incompatibility is introduced.  Minor releases introduce
    # new features.  Fix releases introduce fixes.
    version=version,

    description=(
        '${summary}'),
    long_description=long_description,
    long_description_content_type='text/x-rst',

    # The project's main homepage.
    url='http://pgwui_upload.readthedocs.io/',

    # Author details
    author='${author_name}',
    author_email='${author_email}',

    # Choose your license
    license='AGPLv3+',

    # See https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        # How mature is this project? Common values are
        #   3 - Alpha
        #   4 - Beta
        #   5 - Production/Stable
        'Development Status :: 3 - Alpha',

        # Indicate who your project is intended for
        'Environment :: Web Environment',
        'Framework :: Pyramid',
        'Intended Audience :: End Users/Desktop',
        'Intended Audience :: Information Technology',
        'Intended Audience :: Science/Research',
        'Intended Audience :: System Administrators',
        'Topic :: Database :: Front-Ends',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Scientific/Engineering',
        'Topic :: Utilities',

        # Pick your license as you wish (should match "license" above)
        ('License :: OSI Approved '
         ':: GNU Affero General Public License v3 or later (AGPLv3+)'),

        # Specify the Python versions you support here. In particular, ensure
        # that you indicate whether you support Python 2, Python 3 or both.
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
    ],

    # What does your project relate to?
    keywords=[
        'database front end',
        'interface',
        'Postgres',
        'Postgres user interface',
        'Postgres web interface',
        'PostgreSQL',
        'Postgres front end',
        'user interface',
        'web',
        'web front end',
    ],

    # You can just specify the packages manually here if your project is
    # simple. Or you can use find_packages().
    packages=find_packages('src'),
    package_dir={'': 'src'},

    # Run-time dependencies.
    install_requires=[
        'markupsafe',
        'pgwui_common',
        'pyramid',
    ],

    # List additional groups of dependencies here (e.g. development
    # dependencies). You can install these using the following syntax,
    # for example:
    # $ pip install -e .[testing]
    extras_require={
        'testing': tests_require,
    },

    # If there are data files included in your packages that need to be
    # installed, specify them here.  If using Python 2.6 or less, then these
    # have to be included in MANIFEST.in as well.
    package_data={
        '${component.lower()}': [
            'templates/*.mak',
            'VERSION',
        ],
    },

    # To provide executable scripts, use entry points in preference to the
    # "scripts" keyword. Entry points provide cross-platform support and allow
    # pip to create the appropriate form of executable for the target platform.
    #
    # Setup an entry point to support PGWUI autoconfigure discovery.
    entry_points={
        'pgwui.components': '.${component.lower()} = ${component.lower()}',
        'pgwui.check_settings':
        '.${component.lower()} = ${component.lower()}.check_settings:check_settings'}
)
