# Copyright (C) 2020, 2021 The Meme Factory, Inc.  http://www.karlpinc.com/

# This file is part of PGWUI_Bulk_Upload.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

import pytest

import pgwui_upload_core.check_settings
import pgwui_bulk_upload.check_settings as check_settings

from pgwui_develop import testing

# Activiate the PGWUI pytest plugin
pytest_plugins = ("pgwui",)


# Module packaging test

def test_check_setting_is_pgwui_check_settings(
        pgwui_check_settings_entry_point):
    '''Ensure that pgwui_bulk_upload has a pgwui.check_settings entry point
    '''
    assert (pgwui_check_settings_entry_point(
        'pgwui_bulk_upload.check_settings') is True)


# Mocks

mock_core_check_settings = testing.make_mock_fixture(
    pgwui_upload_core.check_settings, 'check_settings')


# check_settings()

@pytest.mark.unittest
def test_check_settings(mock_core_check_settings):
    '''The setting checking functions are called once, the check_settings()
    call returns all the errors from each mock, the 'map_file' setting
    is a setting and is required
    '''

    expected_errors = ['some error']

    mock_core_check_settings.return_value = expected_errors

    result = check_settings.check_settings({})

    mock_core_check_settings.assert_called_once

    call_args = mock_core_check_settings.call_args[0]
    assert 'map_file' in call_args[1]    # 'map_file' is a setting

    assert result == expected_errors
