# Copyright (C) 2015, 2018, 2020 The Meme Factory, Inc.
# http://www.karlpinc.com/

# This file is part of PGWUI_Testing.
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/>.
#

# Karl O. Pinc <kop@karlpinc.com>

'''Functions used by the pytest_plugin module.
'''

import pkg_resources


def pgwui_entry_point(ep_name):
    '''Test that the supplied pgwui component is a entry point with the
    given name
    '''
    def run(module):
        return (module in
                [entry_point.module_name for entry_point in
                 pkg_resources.iter_entry_points(ep_name)])

    return run
