# Copyright (C) 2017 The Meme Factory, Inc.  http://www.meme.com/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Karl O. Pinc <kop@meme.com>

# Constants
TEST_CONFIG_PATH = 'tests/data/test_config.ini'


#
# Helper functions
#

def multiple_errors(err):
    '''Test for multiple errors'''
    return err.count('\nerror: ') > 0


#
# Helper classes
#

class MockTree():
    '''Mocks the DecisionTree class'''
    def __init__(self, fsdir):
        self.tree = []
        self.fsdir = fsdir

    def extend(self, rownum, pattern, scan):
        '''Produce a decision tree that's easy to represent in tests'''
        self.tree.append((rownum, pattern))
