# Copyright (C) 2017 The Meme Factory, Inc.  http://www.meme.com/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Karl O. Pinc <kop@meme.com>

'''
Report on whether files are "hidden".  Only meaningful on MS Windows.
Only works with Python 3.5 and above.
'''
import platform
import stat
import sys


def python35_plus():
    vi = sys.version_info
    return vi[0] >= 3 and vi[1] >= 5


if python35_plus() and platform.system() == 'Windows':
    def is_hidden(dirobj):
        '''Is the dirobj a MS Windows hidden filesystem object?'''
        return bool(dirobj.stat().st_file_attributes &
                    stat.FILE_ATTRIBUTE_HIDDEN)
else:
    def is_hidden(dirobj):
        return False
