# Copyright (C) 2017 The Meme Factory, Inc.  http://www.meme.com/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Karl O. Pinc <kop@meme.com>

'''
Enforce Barnett's File System Structure
---------------------------------------

Enforce the file name syntax and directory structure specified in
Barnett's documentation.

The structure is specified in a Google Docs spreadsheet.

The program is configured from the enforcer.ini configuration file,
a sample of which is included.  The enforcer.ini file must be located
in a folder called ``enforcer`` in the current directory's parent
directory.

The program checks the current directory (and it's sub-directories).

'''
from . import printout
from . import report
from . import startup


def main():
    (config, analyzer) = startup.make_analyzer()
    printer = printout.Printer(config['stock_parens'])
    report.analyze_dirs(printer, analyzer, config)
