<!--
# Copyright (C) 2017 The Meme Factory, Inc.  http://www.meme.com/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied.  See the License for the specific
# language governing permissions and limitations under the
# License.

# Karl O. Pinc <kop@meme.com>
-->


Enforcer
========

Enforce Barnett's File System Structure
---------------------------------------

Enforce the file name syntax and directory structure specified in
Barnett's documentation.

The structure is specified in a Google Docs spreadsheet.

The program is configured from the enforcer.ini configuration file,
a sample of which is included.


Development
-----------

In Unix development is assisted by a Makefile.  Type ``make help`` for
guidance.

You are free to make an egg or wheel or whatever you wish to use to package
the program.  This example makes an sdist (when in the directory containing
this README):

    python setup.py sdist

Your python package name is in the ``dist`` directory in a file matching the
pattern: ``enforcer-version.suffix``


Installation
------------

Create a directory (i.e folder) named ``enforcer`` in the directory
above the directory which the program is to examine.
This directory holds the program's configuration file and other
files which it requires to run.

Typical installation is in a python virtual environment.  A good place
to put the virtual environment is in the ``enforcer`` directory just
created.

These examples create a python virtual environment and install the
enforcer package.

Unix/Linux example:

    mkdir venv
    virtualenv venv
    ./venv/bin/pip install --upgrade pip           ;# See note
    ./venv/bin/pip install --upgrade setuptools    ;# See note
    ./venv/bin/pip install enforcer-version.suffix

MS Windows example:

    mkdir venv
    virtualenv venv
    .\venv\Scripts\pip install --upgrade pip           && rem See note
    .\venv\Scripts\pip install --upgrade setuptools    && rem See note
    .\venv\Scripts\pip install enforcer-version.suffix

The string ``enforcer-version.suffix`` is the path name to the python
package built during program development.

Note: Installation requires setuptools v20.8.1 or later, released 15
      Apr 2016.  The 2 commands containing ``--upgrade`` ensure the
      presence of the latest version.  Although upgrading is only
      necessary if you have an older virtualenv command, it does not
      hurt to upgrade.

Copy the sample configuration file called
``venv/examples/sample_config.ini`` into the ``enforcer`` directory
and give it the name ``enforcer.ini``.  (The file is
venv\examples\sample_config.ini in MS Windows.)  Or obtain the sample
configuration from the GitHub repo instead of from the virtual
environment.

Edit the ``enforcer.ini`` as needed.  Further configuration
instructions are found in the file itself.

Usage
-----

The program is a command line script.  It is designed to be run from
the directory containing the file structure to be checked.  Assuming
that the virtual environment is installed where recommended above,
change your directory and execute the script as follows:

Unix/Linux example:

    ../enforcer/venv/bin/enforcer

MS Windows example:

    ..\enforcer\venv\Scripts\enforcer

The program produces a report on ``stdout``.  Errors are reported on
``stderr``.  The generated report can be saved to a file using the
``>`` redirection operator as follows:

Unix/Linux example:

    ../enforcer/venv/bin/enforcer > ../enforcer/my_report.txt

MS Windows example:

    ..\enforcer\venv\Scripts\enforcer > ..\enforcer\my_report.txt
